/*  view.h
 *
 *  Copyright (C) 2022 Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFCE_PANEL_PLACES_VIEW_H
#define _XFCE_PANEL_PLACES_VIEW_H

#include <glib.h>
#include <gtk/gtk.h>
#include <libxfce4panel/libxfce4panel.h>

struct _HopmanView
{
  /* plugin */
  XfcePanelPlugin           *plugin;

  /* view */
  GtkWidget                 *button;
  GtkWidget                 *menu;
  
  gchar *command;

  int size;
  GtkOrientation orientation;

  GtkWidget *ebox;
  GtkWidget *image;
  GtkWidget *tooltip_text;
};

typedef struct _HopmanView HopmanView;

/* The following widget is initialized by main(); pList is the menubar
   the items of which are partitions. The ui hooks declared in ../hopman.h
   are in charge of updating the items of this menubar. Each item is a
   submenu of user actions. */

# ifdef MAIN_PROGRAM
HopmanView *view;
guint showflags;
# else
extern HopmanView *view;
extern guint showflags;
# endif

HopmanView* hopman_view_init(XfcePanelPlugin*);
void hopman_view_finalize(HopmanView*);

#endif
