/*  set_icon.c
 * 
 * Forked from https://git.devuan.org/kryn/hopman/src/branch/master/hopman-1.1/GTK2/set_icon.c
 * 
 * All modifications to the original source file are:
 *  - Copyright (C) 2022 Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org> 
 *
 * See the LICENSE file.
 */

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include "hopman.h"
#include "gui.h"

static guint32 u8tou32(const guint8* b)
{
  guint32 u;
  int i;
  for(u=*b, i=1; i<4; i++)
    {
      u <<= 8;
      u |= *(b+i);
    }
  return u;
}

/*============================== PIXBUF DATA ================================*/
#include "icon_32x32"

/*================= Destructor (dummy because data is static) ===============*/
void nop_destroy (guchar *pixels, gpointer data)
{
  /* NO OP */
}

GdkPixbuf* set_icon()
{
  const char *magic = "GdkP";
  guint32 total_len __attribute__((unused));
  guint32 pixdata_type __attribute__((unused));
  guint32 width, height, rowstride;
  const guint8 *pixeldata;
  
  if( strncmp((const char*)icon_32x32, magic, 4) )
    {
      fprintf(stderr, "%s error in function set_icon(): invalid Gdk pixbuf.\n",
	      progname);
      exit(EXIT_FAILURE);
    }

  total_len = u8tou32(icon_32x32+4);
  pixdata_type = u8tou32(icon_32x32+8);
  rowstride = u8tou32(icon_32x32+12);
  width  = u8tou32(icon_32x32+16);
  height = u8tou32(icon_32x32+20);
  pixeldata = icon_32x32 + 24;

  return gdk_pixbuf_new_from_data(pixeldata, GDK_COLORSPACE_RGB, TRUE, 8,
				  width, height, rowstride, nop_destroy, NULL);
}
