/* Read the current directory (assuming it is the root of the device files
   tree (normally /dev) and invoke pm_add_part() for each entry of the
   directory. pm_add_part() will select the device files which make sense.
*/
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>  //access()
#include <mntent.h>
#include <assert.h>
#include "hopman.h"
#include "watch.h"

static char slnk[NAME_MAX+1] = "disk/by-label/";

static char rootdev[NAME_MAX+1] = {0};

// Usage: strncpy_t(str1, sizeof(str1), str2, strlen(str2));
// Copy string "in" with at most "insz" chars to buffer "out", which
// is "outsz" bytes long. The output is always 0-terminated. Unlike
// strncpy(), strncpy_t() does not zero fill remaining space in the
// output buffer:
static
char* strncpy_t(char* out, size_t outsz, const char* in, size_t insz)
{
   assert(outsz > 0);
   while(--outsz > 0 && insz > 0 && *in) { *out++ = *in++; insz--; }
   *out = 0;
   return out;
}

void init_list(void)
{
  DIR *dirp;
  struct dirent *E;
  FILE *fstab = NULL;
  struct mntent *e;
  static char rootdev[NAME_MAX+1];
  
  /*------------------- find out the device where / is mounted -----------*/      
  fstab = setmntent("/etc/mtab", "r");
  if(!fstab)
    {
      fprintf(stderr, _("%s: setmntent(): error trying to open /etc/mtab: '%s'\n"), 
          progname, strerror(errno));
      exit(EXIT_FAILURE);
    }
    
    while( (e = getmntent(fstab)) )
      {
        if(!strncmp(e->mnt_fsname, "/dev", strlen("/dev")) && !strcmp(e->mnt_dir, "/"))
      {            
        DIR *dirp;
        struct dirent *E;
        FILE *fstab = NULL;
        const char *dir = "/sys/block";
        const char *str = strstr(e->mnt_fsname, "/dev") + strlen("/dev");
            
        dirp = opendir(dir);
        if(!dirp)
          {
            fprintf(stderr, _("%s error opening current directory: %s\n"), 
                progname, strerror(errno));
            exit(EXIT_FAILURE);
          };

        while ((errno=0, E=readdir(dirp)))
          {
             if (strstr(E->d_name, ".") || strstr(E->d_name, ".."))
               continue;
                    
             if (!strncmp(str+1, E->d_name, strlen(E->d_name)))
          {
             char path[NAME_MAX+1];
             strncpy_t(path, sizeof(path), "/sys/block/", strlen("/sys/block/"));
             strcat(path, E->d_name);
             strcat(path, "/");
             strcat(path, str+1);
             strcat(path, "/partition");
                    
             // Does '/sys/block/{E->d_name}/{e->mnt_fsname}/partition' exist?
             if(access(path, F_OK) == 0)
               {
                 strncpy_t(rootdev, sizeof(rootdev), E->d_name, strlen(E->d_name));
                 break;
               }
          }     
          }
          closedir(dirp);
      }
  }

  /*------------------------------ Scan /dev --------------------------------*/
  dirp = opendir("/dev");
  if(!dirp)
    {
      fprintf(stderr, _("%s error opening current directory: %s\n"),
	      progname, strerror(errno));
      exit(EXIT_FAILURE);
    }

  /* Invoke partition_new() for all devices associated to hotplug partitions */
  while( (errno=0, E=readdir(dirp)) )
    {
      struct stat devstat;
      if( lstat(E->d_name, &devstat) )
	{
	  fprintf(stderr, _("%s warning: create unknown device %s\n"),
		  progname, E->d_name);
	  return;
	}
      if( (devstat.st_mode & S_IFMT) == S_IFBLK )
	{
	  if(hotplug_partition(E->d_name))
	    {
	      if (strlen(rootdev) > 0)
            {
              partition_new(E->d_ino, E->d_name, rootdev);
            }
          else
            {
              partition_new(E->d_ino, E->d_name, NULL);
            }
	    }
	}
    }
  if(errno)
    {
      fprintf(stderr, _("%s error reading current directory: %s\n"),
	      progname, strerror(errno));
      exit(EXIT_FAILURE);
    }
  closedir(dirp);

  /*------------------------ Scan /dev/disk/by-label ------------------------*/
  dirp = opendir("disk/by-label");
  if(!dirp)
    {
      fprintf(stderr, _("%s cannot open subdirectory disk/by-label: %s\n"),
	      progname, strerror(errno));
      return;
    }

  /* invoke partition_set_label() for every directory entry */
  while( (errno=0, E=readdir(dirp)) )
    {
      struct stat devstat;
      if(!strcmp(E->d_name, ".") || !strcmp(E->d_name, "..")) continue;
      strcpy(slnk+14, E->d_name);
      if( stat(slnk, &devstat) ) continue;
      partition_set_label_by_blkid(slnk);
    }
  if(errno)
    {
      fprintf(stderr, _("%s error reading current directory: %s\n"),
	      progname, strerror(errno));
      exit(EXIT_FAILURE);
    }
  closedir(dirp);

  /* check mountpoints */
  mountpoints();
  return;
}
